extends ColorRect


# Declare member variables here. Examples:
# var a = 2
# var b = "text"
const mps = Vector2(10, 10)

onready var bob: ColorRect = get_node("Bob")
onready var label: Label = get_node("Label")

var upd = 0
var inputs = []


# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	upd += delta

	var ac := Input.get_accelerometer()
	var sz := rect_size

	var pos = Vector2(-ac.x, ac.y) * (sz / 2) / mps + (sz / 2) - (bob.rect_size / 2)
	inputs.push_back(pos)
	while len(inputs) > 10:
		inputs.pop_front()
	var avg = Vector2.ZERO
	for i in inputs:
		avg += i
	avg = avg / 10

	if abs(avg.x - sz.x / 2) > sz.x * 0.3:
		bob.rect_position = Vector2(sz.x / 2 - bob.rect_size.x / 2, avg.y)
	else:
		bob.rect_position = avg

	if upd > 1:
		label.text = "%0.2f %0.2f %0.2f\n%+0.2f %+0.2f\n%0.2f %0.2f" % [ac.x, ac.y, ac.z, avg.x, avg.y, sz.x, sz.y]
		upd = 0
