extends Node2D


var board_cell_size:Vector2
var board_off:Vector2
var board_rect:Rect2
var move := 'red'
var move_tim:Timer
var select

var fourw = [
	Vector2(-1, 1),
	Vector2(1, 1),
	Vector2(-1, -1),
	Vector2(1, -1),
]

var pieces = {
	2 : {
		color = 'black',
		dirs = [
			Vector2(-1, 1),
			Vector2(1, 1),
			],
		promote = 3,
		},
	3 : {
		color = 'black',
		dirs = [
			Vector2(-1, 1),
			Vector2(1, 1),
			Vector2(-1, -1),
			Vector2(1, -1),
			],
		promote = null,
		},
	4 : {
		color = 'red',
		dirs = [
			Vector2(-1, -1),
			Vector2(1, -1),
			],
		promote = 5,
		},
	5 : {
		color = 'black',
		dirs = [
			Vector2(-1, 1),
			Vector2(1, 1),
			Vector2(-1, -1),
			Vector2(1, -1),
			],
		promote = null,
		},
	}


func _ready():
	board_off = $Board.position
	board_cell_size = $Board.cell_size
	board_rect = Rect2(board_off, board_cell_size * 10)
	move_tim = Timer.new()
	move_tim.one_shot = true
	add_child(move_tim)
	move_tim.connect('timeout', self, 'black_move')


func _input(event):
	if event is InputEventMouseButton:
		if event.pressed and move == 'red':
			var loc = event.global_position
			click(loc)


func black_move():
	$Debug.text += '\nTurn'
	var movable = []
	for y in 10:
		for x in 10:
			var loc = Vector2(x, y)
			$Board/Light.set_cellv(loc, -1)

			var pc = $Board.get_cellv(loc)
			var caps = get_caps(loc)
			if can_move(loc) and pieces[pc].color == 'black':
				movable.append(loc)
#				$Board/Light.set_cellv(loc, 0)

	var loc = movable[randi() % len(movable)]
	$Board/Light.set_cellv(loc, 0)
	var pc = $Board.get_cellv(loc)
	var ds = []
	for d in pieces[pc].dirs:
		if $Board.get_cellv(loc + d) == 1:
			ds.append(d)

	assert(len(ds) != 0)

	var loc2 = ds[randi() % len(ds)] + loc
	$Board.set_cellv(loc2, pc)
	$Board.set_cellv(loc, 1)
	$Board/Light.set_cellv(loc2, 0)
	$Board/Light.set_cellv(loc, -1)

	move = 'red'


func can_move(loc:Vector2) -> bool:
	if $Board.get_cellv(loc) < 2:
		return false

	var pc = $Board.get_cellv(loc)

	var ds = pieces[pc].dirs
	var ok = false
	for d in ds:
		var pc2 = $Board.get_cellv(loc + d)
		if pc2 < 1:
			continue

		if pc2 == 1:
			ok = true
		elif pieces[pc2].color != pieces[pc].color:
			pass

	return ok


func click(loc:Vector2):
	if not board_rect.has_point(loc):
		return

	loc = ((loc - board_off) / board_cell_size).floor()

	var h = loc / 2.0
	if int(h.x == int(h.x)) ^ int(h.y == int(h.y)):
		if select == null:
			click_first(loc)
		else:
			$Board/Light.set_cellv(select, -1)
			click_second(loc)
	elif select != null:
		$Board/Light.set_cellv(select, -1)
		select = null


func click_first(loc):
	var pc = $Board.get_cellv(loc)
	if pc >= 4 and can_move(loc):
		select = loc
		$Board/Light.set_cellv(select, 0)


func click_second(loc):
	var pc = $Board.get_cellv(select)
	var pc2 = $Board.get_cellv(loc)

	if pc2 == 1 and (select - loc).length() < 2:
		if pc == 5 or loc.y < select.y:
			$Board.set_cellv(loc, pc)
			$Board.set_cellv(select, 1)
			move = 'black'
			move_tim.start()

	select = null


func non_get_caps(iloc:Vector2) -> Array:
	var caps = []
	var pc = $Board.get_cellv(iloc)

	if pc < 2:
		return caps

#	var q = [iloc]
	var checked = {}
	var loc = iloc
	for d in fourw:
		var pc2 = $Board.get_cellv(loc + d)
		if pc2 < 2:
			continue

		if pieces[pc].color != pieces[pc2].color:
			var pc3 = $Board.get_cellv(loc + d * 2)
			if pc3 == 1 and not checked.has(pc3):
				var e = get_caps(loc + d * 2)
				if e.empty():
					e = loc + d * 2
				var c = {
					cap = loc + d,
					end = e,
					start = loc,
					}
				caps.append(c)

	if not caps.empty():
		$Debug.text += '\n' + str(caps)
	return caps


func get_caps(loc:Vector2, pc=null, checked={}) -> Array:
	var caps = []

	if pc == null:
		pc = $Board.get_cellv(loc)

	if pc < 2:
		return caps

	checked[loc] = true

	for d in fourw:
		var pc2 = $Board.get_cellv(loc + d)
		if pc2 < 2:
			continue

		if pieces[pc].color != pieces[pc2].color:
			var pc3 = $Board.get_cellv(loc + d * 2)
			if pc3 == 1:
				if checked.has(loc + d * 2):
					continue

				checked[loc + d * 2] = true
				var e = get_caps(loc + d * 2, pc, checked)

				if e.empty():
					e = loc + d * 2
				var c = {
					cap = loc + d,
					end = e,
					start = loc,
					}
				caps.append(c)

	if not caps.empty():
		$Debug.text += '\n' + str(caps)
	return caps


# Called every frame. 'delta' is the elapsed time since the previous frame.
#func _process(delta):
#	pass
