extends Node2D


# Declare member variables here. Examples:
# var a = 2
# var b = "text"

const LEGAL_LETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
enum States { GO, FAIL, WIN }

onready var grid := get_node("Borders/VBoxContainer/GridBorder/GridContainer")
onready var edit := get_node("Borders/LineEdit")

#var delta_time = 0
var letter_scene: PackedScene = preload("res://letter.tscn")
var letters := []
var attempt := 0
var target := "eagle"
var state = States.GO


# Called when the node enters the scene tree for the first time.
func _ready():
# warning-ignore:integer_division
	var day_since_epoch = (OS.get_system_time_secs() - 6 * 3600) / (3600 * 24) - 9999
	#print((OS.get_system_time_secs() - 6 * 3600) / (3600 * 24.0) - 9999)
	seed(day_since_epoch)
#	randomize()
#	print(day_since_epoch)

	var f = File.new()
	f.open("res://wordlist.txt", File.READ)
	var length = int(f.get_line())
#	print("length: {0}".format([length]))
	for _i in range(rand_range(0, length)):
		target = f.get_line()
	f.close()

	if len(target) != 5:
		get_tree().quit()
#	print(target)


	for y in range(5):
		letters.append([])
		for _x in range(5):
			var i = letter_scene.instance()
			letters[y].append(i)
			grid.add_child(i)
			i.text = ""
			var b = i.get_node("Back")
#			print(b)
			b.color = Color(0, 0, 0, 0.25)
	edit.grab_focus()
#	OS.show_virtual_keyboard()


#func _unhandled_key_input(event):
#	if event.pressed:
#		print(event.scancode)
#		letters[attempt][0].text = str(event.scancode)


# Called every frame. "delta" is the elapsed time since the previous frame.
#func _process(delta):
#	delta_time = delta_time + delta
#	if delta_time > 1:
#		delta_time = 0
#		if not edit.has_focus():
#			edit.grab_focus()
#			OS.show_virtual_keyboard()


func _on_LineEdit_text_changed(new_text: String):
	if state != States.GO:
		edit.text = ""
		return

	for i in range(5):
		if new_text.substr(i, 1) in LEGAL_LETTERS:
			letters[attempt][i].text = new_text.substr(i, 1).capitalize()
		elif new_text.substr(i, 1) == "":
			letters[attempt][i].text = ""
			edit.text = new_text.substr(0, i)
			edit.caret_position = i
			break
#		else:
#			print("ugh")

	if len(new_text) > 5:
#		print(new_text)
#		print(edit.text)
		edit.text = new_text.substr(0, 5)
#		print(edit.text)
		edit.caret_position = 5

	OS.show_virtual_keyboard(edit.text)


func _on_LineEdit_focus_exited():
#	print("exit")
	pass


func _input(event):
	if state == States.GO:
		if event.is_action_pressed("ui_accept"):
			eol()

func eol():
	if len(edit.text) == 5 and is_word(edit.text):
		var success = mark_line()
		if success == States.WIN:
			good_end()
			return

		attempt += 1
		edit.text = ""
#		print(attempt)
		if attempt >= 5:
			bad_end()
	else:
		clear_line()


func is_word(w):
	var f = File.new()
	f.open("res://wordlist.txt", File.READ)
	while not f.eof_reached():
		var s = f.get_line()
		if s == w:
			f.close()
			return true

	f.close()
	return false


func good_end():
#	print("win")
	state = States.WIN


func bad_end():
#	print("fail")
	state = States.FAIL


func mark_line():
	var used = {}
	var correct = 0

	for i in range(5):
		var in_letter = edit.text.substr(i, 1)
		if in_letter == target.substr(i, 1):
			letters[attempt][i].Back.color = Color(0, 1, 0, 0.5)
			used[i] = true
			correct += 1
		else:
			for j in range(5):
				if not used.get(j) and in_letter == target.substr(j, 1):
					letters[attempt][i].Back.color = Color(1, 1, 0, 0.5)
					used[j] = true

#	print(correct)
	if correct == 5:
#		print('winner')
		return States.WIN

	return States.FAIL


func clear_line():
	for i in range(5):
		letters[attempt][i].text = ""
	edit.text = ""
	edit.grab_focus()
	OS.show_virtual_keyboard(edit.text)
